/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.core.Computer;
import jace.core.Device;
import jace.core.Motherboard;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import java.util.concurrent.locks.LockSupport;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class Speaker
extends Device {
    private double counter = 0.0;
    private int level = 0;
    private int idleCycles = 0;
    static final int BITS = 16;
    static final int RATE = 44100;
    static final int BUFFER_SIZE = 17640;
    static final int MIN_PLAYBACK_BUFFER = 8820;
    private int MIN_SAMPLE_PLAYBACK = 4410;
    static final int VOLUME = 600;
    static final int MAX_IDLE_CYCLES = 2000000;
    private SourceDataLine sdl;
    private AudioFormat af;
    private boolean lineAvailable = true;
    private boolean speakerBit = false;
    private boolean resetBuffer = false;
    private final Object bufferLock = new Object();
    byte[] soundBuffer1 = new byte[17640];
    byte[] soundBuffer2 = new byte[17640];
    int currentBuffer = 1;
    int bufferPos = 0;
    private double TICKS_PER_SAMPLE = (double)Motherboard.SPEED / 44100.0;
    private double TICKS_PER_SAMPLE_FLOOR = Math.floor(this.TICKS_PER_SAMPLE);
    Thread playbackThread;

    public Speaker() throws LineUnavailableException {
        this.initAudio();
        this.configureListener();
    }

    public void suspend() {
        this.speakerBit = false;
        this.sdl.drain();
        this.sdl.stop();
        Motherboard.soundEnabled = false;
        this.playbackThread = null;
    }

    public void resume() {
        if (this.lineAvailable) {
            if (this.playbackThread == null || !this.playbackThread.isAlive()) {
                this.playbackThread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int len = 0;
                        while (Motherboard.soundEnabled) {
                            len = Speaker.this.bufferPos;
                            if (len >= Speaker.this.MIN_SAMPLE_PLAYBACK) {
                                byte[] buffer;
                                Object object = Speaker.this.bufferLock;
                                synchronized (object) {
                                    buffer = Speaker.this.currentBuffer == 1 ? Speaker.this.soundBuffer1 : Speaker.this.soundBuffer2;
                                    Speaker.this.currentBuffer = Speaker.this.currentBuffer == 1 ? 2 : 1;
                                    Speaker.this.bufferPos = 0;
                                }
                                Speaker.this.sdl.write(buffer, 0, len);
                                continue;
                            }
                            LockSupport.parkNanos(5000L);
                        }
                        Speaker.this.sdl.drain();
                        Speaker.this.sdl.flush();
                    }
                });
            }
            this.sdl.flush();
            Motherboard.soundEnabled = true;
            this.setRun(true);
            this.counter = 0.0;
            this.idleCycles = 0;
            this.level = 0;
            this.bufferPos = 0;
            this.playbackThread.start();
        }
    }

    public void resetIdle() {
        this.idleCycles = 0;
        if (!Motherboard.soundEnabled) {
            this.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        if (Motherboard.soundEnabled) {
            if (this.idleCycles++ >= 2000000) {
                this.suspend();
            }
            if (this.speakerBit) {
                ++this.level;
            }
            this.counter += 1.0;
            if (this.counter >= this.TICKS_PER_SAMPLE) {
                while (this.bufferPos >= 17640) {
                    LockSupport.parkNanos(1000L);
                }
                int sample = this.level * 600;
                byte hi = (byte)((0xFF00 & sample) >> 8);
                byte lo = (byte)(0xFF & sample);
                Object object = this.bufferLock;
                synchronized (object) {
                    if (this.currentBuffer == 1) {
                        byte by = hi;
                        this.soundBuffer1[this.bufferPos + 2] = by;
                        this.soundBuffer1[this.bufferPos] = by;
                        byte by2 = lo;
                        this.soundBuffer1[this.bufferPos + 3] = by2;
                        this.soundBuffer1[this.bufferPos + 1] = by2;
                    } else {
                        byte by = hi;
                        this.soundBuffer2[this.bufferPos + 2] = by;
                        this.soundBuffer2[this.bufferPos] = by;
                        byte by3 = lo;
                        this.soundBuffer2[this.bufferPos + 3] = by3;
                        this.soundBuffer2[this.bufferPos + 1] = by3;
                    }
                    this.bufferPos += 4;
                }
                this.level = 0;
                this.counter -= this.TICKS_PER_SAMPLE_FLOOR;
            }
        }
    }

    private void initAudio() throws LineUnavailableException {
        Line l;
        this.af = new AudioFormat(44100.0f, 16, 2, true, true);
        DataLine.Info dli = new DataLine.Info(SourceDataLine.class, this.af);
        for (Mixer.Info mixer : AudioSystem.getMixerInfo()) {
            System.out.println(mixer.getName() + ":" + mixer.getDescription());
        }
        if (AudioSystem.isLineSupported(dli)) {
            l = null;
            try {
                l = AudioSystem.getLine(dli);
            }
            catch (LineUnavailableException e) {
                this.lineAvailable = false;
                throw e;
            }
            if (!(l instanceof SourceDataLine)) {
                this.lineAvailable = false;
                throw new LineUnavailableException("Line is not an output line!");
            }
        } else {
            this.lineAvailable = false;
            throw new LineUnavailableException("Line not supported!");
        }
        this.sdl = (SourceDataLine)l;
        if (this.sdl == null) {
            this.lineAvailable = false;
            throw new LineUnavailableException("line not found");
        }
        if (this.lineAvailable) {
            this.sdl.open(this.af, 17640);
        }
    }

    private void configureListener() {
        Computer.getComputer().getMemory().addListener(new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

            protected void doConfig() {
                this.setScopeStart(49200);
                this.setScopeEnd(49215);
            }

            protected void doEvent(RAMEvent e) {
                Speaker.this.speakerBit = !Speaker.this.speakerBit;
                Speaker.this.resetIdle();
            }
        });
    }

    protected String getDeviceName() {
        return "Speaker";
    }
}

